$(document).ready(function() {
    // Configuración EmailJS (rellenar con tus credenciales)
    const EMAILJS_PUBLIC_KEY = 'REEMPLAZAR_PUBLIC_KEY';
    const EMAILJS_SERVICE_ID = 'REEMPLAZAR_SERVICE_ID';
    const EMAILJS_TEMPLATE_ID = 'REEMPLAZAR_TEMPLATE_ID';
    // Durante la prueba, forzamos el destinatario al correo del usuario
    const FORCE_TEST_RECIPIENT = 'migueljohn2105@gmail.com';
    if (window.emailjs && EMAILJS_PUBLIC_KEY !== 'REEMPLAZAR_PUBLIC_KEY') {
        emailjs.init(EMAILJS_PUBLIC_KEY);
    }
    // Datos para combobox (objetos y arreglos)
    const sedes = ["La Molina", "San Isidro", "Miraflores"]; // array simple
    const especialidades = [
        { id: 1, nombre: "Medicina General" },
        { id: 2, nombre: "Cardiología" },
        { id: 3, nombre: "Pediatría" },
        { id: 4, nombre: "Ginecología" }
    ];

    // Llenar combobox en index y citas
    $("#Id_sede").each(function() {
        $(this).empty();
        // opción placeholder bloqueada por defecto
        $(this).append('<option value="" disabled selected>Selecciona sede</option>');
        // ciclo e iteraciones
        sedes.forEach(sede => $(this).append(`<option>${sede}</option>`));
    });
    $("#Id_especialidad").each(function() {
        $(this).empty();
        $(this).append('<option value="" disabled selected>Selecciona especialidad</option>');
        especialidades.forEach(e => $(this).append(`<option value="${e.id}">${e.nombre}</option>`));
    });

    // Carrusel (Eventos)
    let currentSlide = 0;
    const $slides = $('.carousel-img');
    function showSlide(idx) {
        $slides.removeClass('active').eq(idx).addClass('active');
    }
    showSlide(currentSlide);
    function nextSlide(){
        currentSlide = (currentSlide + 1) % $slides.length;
        showSlide(currentSlide);
    }
    function prevSlide(){
        currentSlide = (currentSlide - 1 + $slides.length) % $slides.length;
        showSlide(currentSlide);
    }
    $('.carousel-btn.next').click(function() {
        nextSlide();
        resetAuto();
    });
    $('.carousel-btn.prev').click(function() {
        prevSlide();
        resetAuto();
    });
    // Autoplay cada 10s
    let timer = setInterval(nextSlide, 10000);
    function resetAuto(){ clearInterval(timer); timer = setInterval(nextSlide, 10000); }

    // Microinteracción: animación en botones (clase helper)
    $('.btn').on('mouseenter', function() { $(this).addClass('hovered'); })
             .on('mouseleave', function() { $(this).removeClass('hovered'); });

    // CRUD Doctores
    let doctores = [
        {nombre: "Dr. William Birkin", especialidad: "Medicina General", cmp: "47698"},
        {nombre: "Dr. Luis Sera", especialidad: "Medicina General", cmp: "074525"},
        {nombre: "Dra. Rebecca Chambers", especialidad: "Medicina General", cmp: "47698"}
    ];
    function renderDoctores() {
        const $list = $("#doctor-list");
        $list.empty();
        doctores.forEach((doc, idx) => {
            $list.append(`
                <div class="doctor-item">
                    <span>${doc.nombre} - ${doc.especialidad} - CMP ${doc.cmp}</span>
                    <span class="doctor-actions">
                        <button onclick="editDoctor(${idx})">Editar</button>
                        <button onclick="deleteDoctor(${idx})">Eliminar</button>
                    </span>
                </div>
            `);
        });
    }
    window.editDoctor = function(idx) {
        const doc = doctores[idx];
        $("#doctor-name").val(doc.nombre);
        $("#doctor-specialty").val(doc.especialidad);
        $("#doctor-cmp").val(doc.cmp);
        $("#doctor-form").data("editIdx", idx);
    }
    window.deleteDoctor = function(idx) {
        doctores.splice(idx, 1);
        renderDoctores();
    }
    $("#doctor-form").submit(function(e) {
        e.preventDefault();
        const nombre = $("#doctor-name").val();
        const especialidad = $("#doctor-specialty").val();
        const cmp = $("#doctor-cmp").val();
        const editIdx = $(this).data("editIdx");
        if (editIdx !== undefined) {
            doctores[editIdx] = {nombre, especialidad, cmp};
            $(this).removeData("editIdx");
        } else {
            doctores.push({nombre, especialidad, cmp});
        }
        this.reset();
        renderDoctores();
    });
    renderDoctores();

    // Formulario contacto con envío por EmailJS
    $("#contact-form").submit(function(e) {
        e.preventDefault();
        const $btn = $(this).find('button[type="submit"]');
        const nombre = $("#nombre").val().trim();
        const email = $("#email").val().trim();
        const celular = $("#celular").val().trim();
        const asunto = $("#asunto").val().trim();
        const mensaje = $("#mensaje").val().trim();

        // Si EmailJS no está configurado aún, mostrar demo y salir
        const emailjsReady = window.emailjs && EMAILJS_PUBLIC_KEY !== 'REEMPLAZAR_PUBLIC_KEY' && EMAILJS_SERVICE_ID !== 'REEMPLAZAR_SERVICE_ID' && EMAILJS_TEMPLATE_ID !== 'REEMPLAZAR_TEMPLATE_ID';

        if (!emailjsReady) {
            alert('EmailJS no está configurado. Coloca tu PUBLIC_KEY, SERVICE_ID y TEMPLATE_ID en public/js/main.js para habilitar el envío automático.');
            $('#formMsg').text('EmailJS no configurado.').css({color: 'crimson'});
            return;
        }

        $btn.prop('disabled', true).text('Enviando...');
        const params = {
            to_email: FORCE_TEST_RECIPIENT || email,
            to_name: nombre,
            subject: asunto,
            message: mensaje,
            phone: celular
        };
        emailjs.send(EMAILJS_SERVICE_ID, EMAILJS_TEMPLATE_ID, params)
            .then(() => {
                alert('¡Mensaje enviado correctamente! Revisa tu bandeja de entrada.');
                $('#formMsg').text('Enviado correctamente.').css({color: 'green'});
                e.target.reset();
            })
            .catch((err) => {
                console.error('EmailJS error:', err);
                alert('Ocurrió un problema al enviar el mensaje. Inténtalo nuevamente.');
                $('#formMsg').text('Error al enviar: ' + (err?.text || 'desconocido')).css({color: 'crimson'});
            })
            .finally(() => {
                $btn.prop('disabled', false).text('Enviar');
            });
    });

    // Filtro de tarjetas de doctores (citas)
    function applyDoctorFilters(){
        const sede = $("#Id_sede").val();
        const espText = $("#Id_especialidad option:selected").text();
        const fecha = $("#date").val(); // año,mes,día
        const doc = ($("#doctor").val() || '').toLowerCase();
        const activeDocSearch = doc.length >= 2; // El tipear 2 letras, se prioriza la búsqueda por nombre

        let visibles = 0;
        $(".doctor-card").each(function(){
            const $card = $(this);
            const cSede = ($card.data('sede') || '').toString();
            const cEsp = ($card.data('especialidad') || '').toString();
            const cNombre = ($card.data('nombre') || '').toString().toLowerCase();
            const cFechas = (($card.data('fechas') || '').toString()).split(',');

            const sedeOk = activeDocSearch || !sede || cSede === sede;
            const espOk = activeDocSearch || !espText || cEsp === espText;
            const nombreOk = !doc || cNombre.includes(doc);
            const fechaOk = !fecha || cFechas.includes(fecha);

            const show = sedeOk && espOk && nombreOk && fechaOk;
            $card.toggle(show);
            if (show) visibles++;
        });
        const $no = $("#noResults");
        if ($no.length){ $no.toggle(visibles === 0); }
    }
    $("#searchBtn").on('click', applyDoctorFilters);
    $("#Id_sede, #Id_especialidad, #date, #doctor").on('change keyup', function(e){ if(e.type==='change' || e.keyCode !== 13){ applyDoctorFilters(); }});
    
    // Menú (navbar) responsive
    const $nav = $('.navbar-collapse');
    function openNav(){ $nav.addClass('navbar-show'); $('body').addClass('no-scroll'); }
    function closeNav(){ $nav.removeClass('navbar-show'); $('body').removeClass('no-scroll'); }
    $('.navbar-show-btn').on('click', openNav);
    $('.navbar-hide-btn').on('click', closeNav);
    // close when clicking a nav link
    $('.navbar-nav .nav-link, .navbar-nav .nav-cta').on('click', closeNav);
    // cerrar al hacer clic exterior
    $(document).on('click', function(e){
        if ($nav.hasClass('navbar-show')){
            const within = $(e.target).closest('.navbar-collapse, .navbar-show-btn').length > 0;
            if (!within) closeNav();
        }
    });
    // cerrar con la tecla ESC
    $(document).on('keydown', function(e){ if(e.key === 'Escape') closeNav(); });
    // Asegúrese de que esté cerrado al cambiar el tamaño al escritorio.
    $(window).on('resize', function(){ if (window.innerWidth >= 1200) { closeNav(); } });

    // Navbar shadow en el scroll
    const $navbar = $('.navbar');
    function onScroll(){
        if (window.scrollY > 10) $navbar.addClass('scrolled');
        else $navbar.removeClass('scrolled');
    }
    onScroll();
    $(window).on('scroll', onScroll);
});
