<?php
// Se incluyen los archivos necesarios
require_once("../config/conexion.php");
require_once("../models/Reserva.php");

// Se crea una instancia de la clase Reserva
$reserva = new Reserva();

switch ($_GET["op"]) {
    case "guardaryeditar":
        var_dump($_POST);
        if (empty($_POST["id_registro"])) {
            $reserva->insert_registro(
                $_POST["r_dni"],
                $_POST["r_nombre_std"],
                $_POST["id_mac"],
                $_POST["id_wacom"],
                $_POST["r_estado"],
                $_POST["r_curso"],
                $_POST["r_observ_pre"],
                $_POST["id_usuario"]
            );
        } else {
            $reserva->update_registro(
                $_POST["id_registro"],
                $_POST["r_dni"],
                $_POST["r_nombre_std"],
                $_POST["id_mac"],
                $_POST["id_wacom"],
                $_POST["r_estado"],
                $_POST["r_curso"],
                $_POST["r_observ_pos"],
                $_SESSION["id_usuario"]
            );
        }
        break;

    case "listar":
        $datos = $reserva->get_registro();
        $data = array();
        $id_rol = $_SESSION["id_rol"]; // Obtener el rol del usuario actual


        foreach ($datos as $row) {
            $sub_array = array();
            $sub_array[] = $row["id_registro"];
            $sub_array[] = $row["r_dni"];
            $sub_array[] = $row["r_nombre_std"];
            $sub_array[] = $row["s_nombre"];
            $sub_array[] = $row["l_nombre"];
            $sub_array[] = $row["m_nombre"];
            $sub_array[] = $row["w_nombre"];
            if ($row["r_estado"] == "R") {
                $sub_array[] = '<span class="label label-pill label-warning">Reservado</span>';
            } else {
                $sub_array[] = '<span class="label label-pill label-success">Libre</span>';
            }
            $sub_array[] = '<button type="button" onClick="cerrar(' . $row["id_registro"] . ');"  id="' . $row["id_registro"] . '" class="btn btn-inline btn-warning btn-sm ladda-button"><i class="fa fa-minus"></i></button>';
            $sub_array[] = $row["r_curso"];
            $sub_array[] = $row["r_observ_pre"];
            $sub_array[] = $row["r_observ_pos"];
            $sub_array[] = $row["r_p_hora"];
            $sub_array[] = $row["r_d_hora"];
            $sub_array[] = $row["u_usuario"];
            //$sub_array[] = $row["R_FECHA"];
            $sub_array[] = $row["mod_usuario"] ? $row["mod_usuario"] : "Sin modificaciones";
            $sub_array[] = $row["r_fecha_mod"];
            $sub_array[] = '<button type="button" onClick="editar(' . $row["id_registro"] . ');"  id="' . $row["id_registro"] . '" class="btn btn-inline btn-primary btn-sm ladda-button"><i class="fa fa-edit"></i></button>';
            if ($id_rol != 2) {
                $sub_array[] = '<button type="button" onClick="eliminar(' . $row["id_registro"] . ');"  id="' . $row["id_registro"] . '" class="btn btn-inline btn-danger btn-sm ladda-button"><i class="fa fa-trash"></i></button>';
            } else {
                $sub_array[] = ''; // Dejar vacío si el usuario no tiene permiso para eliminar
            }
            $data[] = $sub_array;
        }
        $results = array(
            "sEcho" => 1,
            "iTotalRecords" => count($data),
            "iTotalDisplayRecords" => count($data),
            "aaData" => $data
        );
        echo json_encode($results);
        break;

    case "cerrar":
        $reserva->cerrar_registro($_POST["id_registro"]);
        break;

    case "eliminar":
        $reserva->delete_registro($_POST["id_registro"]);
        break;

    case "mostrar":
        $datos = $reserva->get_registro_por_id($_POST["id_registro"]);
        if (is_array($datos) == true && count($datos) > 0) {
            foreach ($datos as $row) {
                $output["id_registro"] = $row["id_registro"];
                $output["r_dni"] = $row["r_dni"];
                $output["r_nombre_std"] = $row["r_nombre_std"];
                $output["id_sede"] = $row["id_sede"];
                $output["id_lab"] = $row["id_lab"];
                $output["id_mac"] = $row["id_mac"];
                $output["id_wacom"] = $row["id_wacom"];
                $output["r_estado"] = $row["r_estado"];
                $output["r_curso"] = $row["r_curso"];
                $output["r_observ_pos"] = $row["r_observ_pos"];
            }
            echo json_encode($output);
        } else {
            echo json_encode(["error" => "No se encontraron datos"]);
        }
        break;

    case "combo_sede":
        $datos = $reserva->get_sede();
        $html = "";
        if (is_array($datos) == true and count($datos) > 0) {
            foreach ($datos as $row) {
                $html .= "<option value='" . $row['id_sede'] . "'>" . $row['s_nombre'] . "</option>";
            }
            echo $html;
        }
        break;

    case "combo_laboratorio":
        if(isset($_POST["id_sede"])) {
            $datos=$reserva->get_laboratorio($_POST["id_sede"]);
            $html="";
            if(is_array($datos)==true and count($datos)>0){
                foreach($datos as $row)
                {
                    $html.="<option value='".$row['id_lab']."'>".$row['l_nombre']."</option>";
                }
                echo $html;
            }
        }
        break;
        

    case "combo_mac":
        if(isset($_POST["id_lab"])) {
            $datos=$reserva->get_mac($_POST["id_lab"]);
            $html="";
            if(is_array($datos)==true and count($datos)>0){
                foreach($datos as $row)
                {
                    $html.="<option value='".$row['id_mac']."'>".$row['m_nombre']."</option>";
                }
                echo $html;
            }
        }
        break;

    case "combo_wacom":
        $datos = $reserva->get_wacom();
        $html = "";
        if (is_array($datos) == true and count($datos) > 0) {
            foreach ($datos as $row) {
                $html .= "<option value='" . $row['id_wacom'] . "'>" . $row['w_nombre'] . "</option>";
            }
            echo $html;
        }
        break;

    case "verificar_mac":
        $id_mac = $_POST["id_mac"];
        $id_wacom = isset($_POST["id_wacom"]) ? $_POST["id_wacom"] : null;
        $datos = $reserva->verificar_mac($id_mac, $id_wacom);
        echo json_encode($datos);
        break;

    case "verificar_wacom":
        $id_wacom = $_POST["id_wacom"];
        $datos = $reserva->verificar_wacom($id_wacom);
        echo json_encode($datos);
        break;
}
