<?php
class Reserva extends Conectar
{

    public function insert_registro($r_dni, $r_nombre_std, $id_mac, $id_wacom, $r_estado, $r_curso, $r_observ_pre, $id_usuario)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "INSERT INTO tm_registro (id_registro, r_dni, r_nombre_std, id_mac, id_wacom, r_estado, r_p_hora, r_d_hora, r_curso, r_observ_pre, r_observ_pos, id_usuario, r_fecha, id_usuario_mod, r_fecha_mod) VALUES (NULL, ?, ?, ?, ?, ?, NOW(), NULL, ?, ?, NULL, ?, NOW(), NULL, NULL)";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $r_dni);
        $sql->bindValue(2, $r_nombre_std);
        $sql->bindValue(3, $id_mac);
        $sql->bindValue(4, $id_wacom);
        $sql->bindValue(5, $r_estado);
        $sql->bindValue(6, $r_curso);
        $sql->bindValue(7, $r_observ_pre);
        $sql->bindValue(8, $id_usuario);
        $sql->execute();
        return $sql->rowCount();
    }

    public function update_registro($id_registro, $r_dni, $r_nombre_std, $id_mac, $id_wacom, $r_estado, $r_curso, $r_observ_pos, $id_usuario_mod)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "UPDATE tm_registro 
            SET r_dni=?, 
                r_nombre_std=?, 
                id_mac=?, 
                id_wacom=?, 
                r_estado=?, 
                r_curso=?, 
                r_observ_pos=?, 
                id_usuario_mod=?, 
                r_fecha_mod=NOW() 
            WHERE id_registro=?";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $r_dni);
        $sql->bindValue(2, $r_nombre_std);
        $sql->bindValue(3, $id_mac);
        $sql->bindValue(4, $id_wacom);
        $sql->bindValue(5, $r_estado);
        $sql->bindValue(6, $r_curso);
        $sql->bindValue(7, $r_observ_pos);
        $sql->bindValue(8, $id_usuario_mod);
        $sql->bindValue(9, $id_registro);
        $sql->execute();
        return $sql->rowCount();
    }

    public function cerrar_registro($id_registro)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "UPDATE tm_registro SET r_estado = 'L', r_d_hora = NOW() WHERE id_registro=?";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $id_registro);
        $sql->execute();
        return $sql->rowCount();
    }

    public function delete_registro($id_registro)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "DELETE FROM tm_registro WHERE id_registro=?";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $id_registro);
        $sql->execute();
        return $sql->rowCount();
    }

    public function get_registro()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT 
            R.id_registro,
            R.r_dni,
            R.r_nombre_std,
            SE.id_sede,
            SE.s_nombre,
            L.id_lab,
            L.l_nombre,
            M.id_mac,
            M.m_nombre,
            W.id_wacom,
            W.w_nombre,
            R.r_estado,
            R.r_p_hora,
            R.r_d_hora,
            R.r_curso,
            R.r_observ_pre,
            R.r_observ_pos,
            U.id_usuario,
            U.u_usuario,
            U.u_nombre,
            U.u_apellido,
            R.r_fecha,
            R.id_usuario_mod,
            UM.u_usuario AS mod_usuario, -- Obtiene el u_usuario del usuario que editó
            R.r_fecha_mod
            FROM tm_registro R
            INNER JOIN tm_mac M ON R.id_mac = M.id_mac
            INNER JOIN tm_laboratorio L ON M.id_lab = L.id_lab
            INNER JOIN tm_sede SE ON L.id_sede = SE.id_sede
            INNER JOIN tm_usuario U ON R.id_usuario = U.id_usuario
            LEFT JOIN tm_usuario UM ON R.id_usuario_mod = UM.id_usuario -- Unión para obtener el editor
            LEFT JOIN tm_wacom W ON R.id_wacom = W.id_wacom;";
        $sql = $conectar->prepare($sql);
        $sql->execute();
        return $sql->fetchAll();
    }

    public function get_registro_por_id($id_registro)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT 
            R.id_registro,
            R.r_dni,
            R.r_nombre_std,
            SE.id_sede,
            SE.s_nombre,
            L.id_lab,
            L.l_nombre,
            M.id_mac,
            M.m_nombre,
            W.id_wacom,
            W.w_nombre,
            R.r_estado,
            R.r_p_hora,
            R.r_d_hora,
            R.r_curso,
            R.r_observ_pre,
            R.r_observ_pos,
            U.id_usuario,
            U.u_usuario,
            R.r_fecha,
            R.id_usuario_mod,
            R.r_fecha_mod
            FROM tm_registro R
            INNER JOIN tm_mac M ON R.id_mac = M.id_mac
            INNER JOIN tm_laboratorio L ON M.id_lab = L.id_lab
            INNER JOIN tm_sede SE ON L.id_sede = SE.id_sede
            INNER JOIN tm_usuario U ON R.id_usuario = U.id_usuario
            LEFT JOIN tm_wacom W ON R.id_wacom = W.id_wacom
            WHERE id_registro=?";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $id_registro);
        $sql->execute();
        return $sql->fetchAll();
    }

    public function get_sede()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM tm_sede";
        $sql = $conectar->prepare($sql);
        $sql->execute();
        return $sql->fetchAll();
    }

    public function get_laboratorio($id_sede)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM tm_laboratorio WHERE id_sede = ?
    ORDER BY tm_laboratorio.l_nombre ASC";
        $sql = $conectar->prepare($sql);
        $sql->execute(array($id_sede));
        return $sql->fetchAll();
    }

    public function get_mac($id_lab)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM tm_mac WHERE id_lab = ?";
        $sql = $conectar->prepare($sql);
        $sql->execute(array($id_lab));
        return $sql->fetchAll();
    }

    public function get_wacom()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM tm_wacom";
        $sql = $conectar->prepare($sql);
        $sql->execute();
        return $sql->fetchAll();
    }

    public function verificar_mac($id_mac, $id_wacom = null)
    {
        $conectar = parent::conexion();
        parent::set_names();

        // Validar si id_mac ya está ocupado con estado 'R'
        $sql = "SELECT * FROM tm_registro WHERE id_mac = ? AND r_estado = 'R'";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $id_mac);
        $sql->execute();
        $macResult = $sql->fetchAll(PDO::FETCH_ASSOC);

        // Si id_wacom no es nulo, validar también su estado
        if ($id_wacom !== null && $id_wacom !== '1') {
            $sql = "SELECT * FROM tm_registro WHERE id_wacom = ? AND r_estado = 'R'";
            $sql = $conectar->prepare($sql);
            $sql->bindValue(1, $id_wacom);
            $sql->execute();
            $wacomResult = $sql->fetchAll(PDO::FETCH_ASSOC);

            // Retornar error si cualquiera de los dos está ocupado
            if (!empty($macResult) || !empty($wacomResult)) {
                return array_merge($macResult, $wacomResult);
            }
        }

        return $macResult; // Retornar solo la validación de MAC si no hay WACOM
    }
    public function verificar_wacom($id_wacom)
    {
        $conectar = parent::conexion();
        parent::set_names();

        // Ignorar la validación si id_wacom es '1'
        if ($id_wacom === '1') {
            return []; // Retornar un array vacío para evitar errores
        }

        $sql = "SELECT * FROM tm_registro WHERE id_wacom = ? AND r_estado = 'R'";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $id_wacom);
        $sql->execute();
        return $sql->fetchAll(PDO::FETCH_ASSOC);
    }
}
