var tabla;

function init() {
    $("#reserva_form").on("submit", function (e) {
        guardaryeditar(e);
    });
}

/* Guardar o editar datos */
function guardaryeditar(e) {
    e.preventDefault();
    var formData = new FormData($("#reserva_form")[0]);
    var idMac = $('#id_mac').val(); // Obtener el valor de id_mac
    var idWacom = $('#id_wacom').val(); // Obtener el valor de id_wacom
    var idRegistro = $('#id_registro').val(); // Obtener el valor de id_registro

    // Si no hay id_registro, significa que es un nuevo registro
    if (!idRegistro) {
        // Verificar si el id_mac o id_wacom ya están en uso con estado "P"
        $.post("../../controller/alumno.php?op=verificar_mac", { id_mac: idMac, id_wacom: idWacom }, function (data) {
            data = JSON.parse(data);
            if (data.length > 0) {
                // Si ya existe un registro con id_mac o id_wacom y estado "P", mostrar error
                swal({
                    title: "Error",
                    text: "La máquina o el equipo Wacom seleccionado ya están en uso.",
                    type: "error",
                    confirmButtonClass: "btn-danger"
                });
            } else {
                // Si no hay conflicto, proceder con la creación
                guardarRegistro(formData);
            }
        });
    } else {
        // Si es una edición, proceder directamente
        guardarRegistro(formData);
    }
}

/* Función para guardar o editar el registro */
function guardarRegistro(formData) {
    $.ajax({
        url: "../../controller/alumno.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function (datos) {
            console.log(datos);
            $('#reserva_form')[0].reset();
            $("#modalalumno").modal('hide');
            $('#reserva_data').DataTable().ajax.reload();
            swal({
                title: "Registro!",
                text: "Completado.",
                type: "success",
                confirmButtonClass: "btn-success"
            });
        }
    });
}

$(document).ready(function () {

    // Escuchar cambios en el toggle switch
    $("#requiere_wacom_toggle").on("change", function () {
        toggleWacomOptions();
    });

    // Inicializar el estado del toggle al cargar
    toggleWacomOptions();


    tabla = $('#reserva_data').dataTable({
        "aProcessing": true,
        "aServerSide": true,
        dom: '<"top"f>rt<"bottom"lp><"clear">', // Mueve el buscador a la parte superior izquierda
        "searching": true,
        lengthChange: false,
        colReorder: true,
        "ajax": {
            url: '../../controller/alumno.php?op=listar',
            type: "post",
            dataType: "json",
            error: function (e) {
                console.log(e.responseText);
            }
        },
        "bDestroy": true,
        "responsive": true,
        "bInfo": true,
        "iDisplayLength": 10,
        "autoWidth": false,
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando un total de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando un total de 0 registros",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            },
            "oAria": {
                "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
                "sSortDescending": ": Activar para ordenar la columna de manera descendente"
            }
        }
    }).DataTable();

    /* Seccion de Comboboxes */
    $.post("../../controller/alumno.php?op=combo_sede", function (data) {
        var defaultOption = '<option value="" disabled selected>Seleccione</option>';
        $('#id_sede').html(defaultOption + data);
    });

    // Cambiar Laboratorio según la Sede seleccionada
    $('#id_sede').on('change', function () {
        var idSede = $(this).val();
        if (idSede) {
            $.post("../../controller/alumno.php?op=combo_laboratorio", { id_sede: idSede }, function (data) {
                $('#id_lab').html('<option value="" disabled selected>Seleccione</option>' + data);
            });
        }
    });

    // Cambiar MAC según el Laboratorio seleccionado
    $('#id_lab').on('change', function () {
        var idLab = $(this).val();
        if (idLab) {
            $.post("../../controller/alumno.php?op=combo_mac", { id_lab: idLab }, function (data) {
                $('#id_mac').html(data);
            });
        }
    });

    $.post("../../controller/alumno.php?op=combo_wacom", function (data) {
        $('#id_wacom').html(data);
    });

    $('#id_sede').select2({
        dropdownParent: $('.modal-body')
    });

    $('#id_lab').select2({
        dropdownParent: $('.modal-body')
    });

    $('#id_mac').select2({
        dropdownParent: $('.modal-body')
    });

    $('#id_wacom').select2({
        dropdownParent: $('.modal-body')
    });


    // Ocultar el campo "Requiere Equipo Wacom" si el laboratorio es 4, 5, 6 o 7
    $('#id_lab').on('change', function () {
        var idLab = $(this).val();
        if (["4", "5", "6", "7"].includes(idLab)) {
            // Oculta el bloque del toggle y el de wacom
            $('#requiere_wacom_toggle').closest('.col-lg-8').hide();
            $('#wacom_options').hide();
        } else {
            $('#requiere_wacom_toggle').closest('.col-lg-8').show();
            // Solo mostrar el bloque de wacom si el toggle está activo
            if ($('#requiere_wacom_toggle').is(':checked')) {
                $('#wacom_options').show();
            }
        }
    });
});

/* Ocultar o mostrar el kit-Wacom según el estado del toggle */
function toggleWacomOptions() {
    var wacomOptions = document.getElementById('wacom_options');
    var requiereWacom = document.getElementById('requiere_wacom_toggle').checked;

    if (requiereWacom) {
        wacomOptions.style.display = 'block';
        // Sincronizar el valor de id_wacom con id_mac solo si no estamos en edición
        if (!$('#id_registro').val()) {
            var idMacValue = $('#id_mac').val();
            $('#id_wacom').val(idMacValue).trigger('change');
        }
    } else {
        wacomOptions.style.display = 'none';
        // Establecer el valor de id_wacom a '1' solo si no estamos en edición
        if (!$('#id_registro').val()) {
            $('#id_wacom').val('1').trigger('change');
        }
    }
}

/* Cambiar estado del registro: Mensaje de confirmación */
function cerrar(id_registro) {
    swal({
        title: "Registro",
        text: "¿Cambiar de estado a libre?",
        type: "warning",
        showCancelButton: true,
        confirmButtonClass: "btn-warning",
        confirmButtonText: "Sí",
        cancelButtonText: "No",
        closeOnConfirm: false
    },
        function (isConfirm) {
            if (isConfirm) {
                $.post("../../controller/alumno.php?op=cerrar", { id_registro: id_registro }, function (data) {
                });

                $('#reserva_data').DataTable().ajax.reload();

                swal({
                    title: "Registro!",
                    text: "Registro modificado.",
                    type: "success",
                    confirmButtonClass: "btn-success"
                });
            }
        });
}

/* Ocultar o mostrar el kit-Wacom según el estado del toggle */
function toggleWacomOptions() {
    var wacomOptions = document.getElementById('wacom_options');
    var requiereWacom = document.getElementById('requiere_wacom_toggle').checked;
    if (requiereWacom) {
        wacomOptions.style.display = 'block';
        // Sincronizar el valor de id_wacom con id_mac solo si no estamos en edición
        if (!$('#id_registro').val()) {
            var idMacValue = $('#id_mac').val();
            $('#id_wacom').val(idMacValue).trigger('change');
        }
    } else {
        wacomOptions.style.display = 'none';
        // Establecer el valor de id_wacom a '' solo si no estamos en edición
        if (!$('#id_registro').val()) {
            $('#id_wacom').val('').trigger('change');
        }
    }
}

/* Escuchar cambios en el combobox de Número de MAC */
$('#id_mac').on('change', function () {
    var requiereWacom = document.getElementById('requiere_wacom_toggle').checked;
    if (requiereWacom) {
        // Sincronizar el valor de id_wacom con id_mac si el checkbox está activado
        var idMacValue = $(this).val();
        $('#id_wacom').val(idMacValue).trigger('change');
    }
});

/* Escuchar cambios en el checkbox de Requiere Equipo Wacom */
$('#requiere_wacom_toggle').on('change', function () {
    toggleWacomOptions();
});


/* Limpiar inputs */
$(document).on("click", "#btnnuevo", function () {
    $('#id_registro').val('');
    $('#mdltitulo').html('Nuevo Registro');
    $('#reserva_form')[0].reset();
    $('#requiere_wacom_toggle').prop('checked', false); // Resetear el toggle
    toggleWacomOptions();

    // Restablecer los comboboxes a su estado inicial
    $('#id_sede').val('').trigger('change'); // Restablecer id_sede
    $('#id_lab').val('').trigger('change'); // Restablecer id_lab
    $('#id_mac').val('').trigger('change'); // Restablecer id_mac
    $('#id_wacom').val('').trigger('change'); // Restablecer id_wacom

    $('#pre_observaciones_container').show();
    $('#pos_observaciones_container').hide();
    $('#modalalumno').modal('show');
});
init();