var tabla;

function init(){
    $("#usuario_form").on("submit",function(e){
        guardaryeditar(e);	
    });
}

/* TODO: Guardar datos de los input */
function guardaryeditar(e){
    e.preventDefault();
	var formData = new FormData($("#usuario_form")[0]);
    $.ajax({
        url: "../../controller/usuario.php?op=guardaryeditar",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function(datos){    
            console.log(datos);
            $('#usuario_form')[0].reset();
            $("#modalusuario").modal('hide');
            $('#usuario_data').DataTable().ajax.reload();
            swal({
                title: "Usuario!",
                text: "Completado.",
                type: "success",
                confirmButtonClass: "btn-success"
            });
        }
    }); 
}

$(document).ready(function(){

    $('#id_rol').select2({
        dropdownParent: $('#modalusuario')
    });

    tabla = $('#usuario_data').dataTable({
        "aProcessing": true,
        "aServerSide": true,
        dom: '<"top"f>rt<"bottom"lp><"clear">', // Mueve el buscador a la parte superior izquierda
        "searching": true,
        lengthChange: false,
        colReorder: true,
        "ajax": {
            url: '../../controller/usuario.php?op=listar',
            type: "post",
            dataType: "json",
            error: function (e) {
                console.log(e.responseText);
            }
        },
        "bDestroy": true,
        "responsive": true,
        "bInfo": true,
        "iDisplayLength": 10,
        "autoWidth": false,
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "Ningún dato disponible en esta tabla",
            "sInfo": "Mostrando un total de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando un total de 0 registros",
            "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sLast": "Último",
                "sNext": "Siguiente",
                "sPrevious": "Anterior"
            }
        }
    }).DataTable();
});

/* TODO: Mostrar informacion segun ID en los inputs */
function editar(id_usuario){
    $('#mdltitulo').html('Editar Registro');
    // Oculta el campo de contraseña al editar
    $('#grupo_pass').hide();
    $('#u_pass').prop('required', false);

    /* TODO: Mostrar Informacion en los inputs */
    $.post("../../controller/usuario.php?op=mostrar", {id_usuario : id_usuario}, function (data) {
        data = JSON.parse(data);
        $('#id_usuario').val(data.id_usuario);
        $('#id_rol').val(data.id_rol).trigger('change');
        $('#u_nombre').val(data.u_nombre);
        $('#u_apellido').val(data.u_apellido);
        $('#u_correo').val(data.u_correo);
        $('#u_usuario').val(data.u_usuario);
    }); 

    /* TODO: Mostrar Modal */
    $('#modalusuario').modal('show');
}

/* Cambiar estado del registro: Mensaje de confirmación */
function restablecer(id_usuario) {
    swal({
        title: "Usuario",
        text: "¿Reestablecer contraseña del usuario?",
        type: "warning",
        showCancelButton: true,
        confirmButtonClass: "btn-warning",
        confirmButtonText: "Sí",
        cancelButtonText: "No",
        closeOnConfirm: false
    },
        function (isConfirm) {
            if (isConfirm) {
                $.post("../../controller/usuario.php?op=restablecer", { id_usuario: id_usuario }, function (data) {
                });

                $('#usuario_data').DataTable().ajax.reload();

                swal({
                    title: "Usuario!",
                    text: "Contraseña modificada.",
                    type: "success",
                    confirmButtonClass: "btn-success"
                });
            }
        });
}

/* TODO: Cambiar estado a eliminado en caso de confirmar mensaje */
function eliminar(id_usuario){
    swal({
        title: "Usuario",
        text: "Esta seguro de Eliminar el usuario?",
        type: "error",
        showCancelButton: true,
        confirmButtonClass: "btn-danger",
        confirmButtonText: "Si",
        cancelButtonText: "No",
        closeOnConfirm: false
    },
    function(isConfirm) {
        if (isConfirm) {
            $.post("../../controller/usuario.php?op=eliminar", {id_usuario : id_usuario}, function (data) {

            }); 

            $('#usuario_data').DataTable().ajax.reload();	

            swal({
                title: "Usuario!",
                text: "Registro Eliminado.",
                type: "success",
                confirmButtonClass: "btn-success"
            });
        }
    });
}

/* TODO: Limpiar Inputs */
$(document).on("click","#btnnuevo", function(){
    $('#id_usuario').val('');
    $('#mdltitulo').html('Nuevo Registro');
    $('#usuario_form')[0].reset();
    $('#grupo_pass').show(); // Mostrar el campo contraseña
    $('#u_pass').prop('required', true); // Hacer el campo contraseña obligatorio
    $('#modalusuario').modal('show');
});

init();