<?php
// Se incluyen los archivos necesarios
require_once("../config/conexion.php");
require_once("../models/Usuario.php");

// Se crea una instancia de la clase Usuario
$usuario = new Usuario();

switch ($_GET["op"]) {
    case "guardaryeditar":
        if (empty($_POST["id_usuario"])) {
            $usuario->insert_usuario(
                $_POST["id_rol"],
                $_POST["u_nombre"],
                $_POST["u_apellido"],
                $_POST["u_correo"],
                $_POST["u_usuario"],
                $_POST["u_pass"]
            );
        } else {
            $usuario->update_usuario(
                $_POST["id_usuario"],
                $_POST["id_rol"],
                $_POST["u_nombre"],
                $_POST["u_apellido"],
                $_POST["u_correo"],
                $_POST["u_usuario"]
            );
        }
        break;

    case "listar":
        $datos = $usuario->get_usuario();
        $data = array();
        foreach ($datos as $row) {
            $sub_array = array();

            $sub_array[] = $row["id_usuario"];

            switch ($row["id_rol"]) {
                case "1":
                    $sub_array[] = '<span class="label label-pill label-warning">Administrador</span>';
                    break;
                case "2":
                    $sub_array[] = '<span class="label label-pill label-info">Trabajador</span>';
                    break;
                case "3":
                    $sub_array[] = '<span class="label label-pill label-success">Alumno</span>';
                    break;
                default:
                    $sub_array[] = '<span class="label label-pill label-default">Desconocido</span>';
                    break;
            }
            $sub_array[] = $row["u_nombre"];
            $sub_array[] = $row["u_apellido"];
            $sub_array[] = $row["u_correo"];
            $sub_array[] = $row["u_usuario"];

            $sub_array[] = '<button type="button" onClick="editar(' . $row["id_usuario"] . ');"  id="' . $row["id_usuario"] . '" class="btn btn-inline btn-primary btn-sm ladda-button"><i class="fa fa-edit"></i></button>';
            $sub_array[] = '<button type="button" onClick="restablecer(' . $row["id_usuario"] . ');"  id="' . $row["id_usuario"] . '" class="btn btn-inline btn-warning btn-sm ladda-button"><i class="fa fa-undo"></i></button>';
            $sub_array[] = '<button type="button" onClick="eliminar(' . $row["id_usuario"] . ');"  id="' . $row["id_usuario"] . '" class="btn btn-inline btn-danger btn-sm ladda-button"><i class="fa fa-trash"></i></button>';

            $data[] = $sub_array;
        }
        $results = array(
            "sEcho" => 1,
            "iTotalRecords" => count($data),
            "iTotalDisplayRecords" => count($data),
            "aaData" => $data
        );
        echo json_encode($results);
        break;

    case "restablecer":
        $usuario->restablecer_password($_POST["id_usuario"]);
        break;

    case "eliminar":
        $usuario->delete_usuario($_POST["id_usuario"]);
        break;

    case "mostrar":
        $datos = $usuario->get_usuario_por_id($_POST["id_usuario"]);
        if (is_array($datos) == true && count($datos) > 0) {
            foreach ($datos as $row) {
                $output["id_usuario"] = $row["id_usuario"];
                $output["id_rol"] = $row["id_rol"];
                $output["u_nombre"] = $row["u_nombre"];
                $output["u_apellido"] = $row["u_apellido"];
                $output["u_correo"] = $row["u_correo"];
                $output["u_usuario"] = $row["u_usuario"];
                $output["u_pass"] = $row["u_pass"];
            }
            echo json_encode($output);
        } else {
            echo json_encode(["error" => "No se encontraron datos"]);
        }
        break;

    case "password":
        $usuario->update_pass($_POST["id_usuario"], $_POST["u_pass"]);
        break;
}
