<?php
class Usuario extends Conectar
{
    public function login()
    {
        $conectar = parent::conexion();
        parent::set_names();
        if (isset($_POST["enviar"])) {
            $u_usuario = $_POST["u_usuario"];
            $u_pass = $_POST["u_pass"];
            if (empty($u_usuario) || empty($u_pass)) {
                header("Location:" . conectar::ruta() . "view/login/index.php?m=2");
                exit();
            } else {
                $sql = "SELECT * FROM tm_usuario WHERE u_usuario=? AND u_pass=?";
                $sql = $conectar->prepare($sql);
                $sql->bindValue(1, $u_usuario);
                $sql->bindValue(2, $u_pass);
                $sql->execute();
                $resultado = $sql->fetch();
                if (is_array($resultado) && count($resultado) > 0) {
                    $_SESSION["id_usuario"] = $resultado["id_usuario"];
                    $_SESSION["u_nombre"] = $resultado["u_nombre"];
                    $_SESSION["u_apellido"] = $resultado["u_apellido"];
                    $_SESSION["u_correo"] = $resultado["u_correo"];
                    $_SESSION["id_rol"] = $resultado["id_rol"];
                    header("Location:" . conectar::ruta() . "view/tablero/");
                    exit();
                } else {
                    header("Location:" . conectar::ruta() . "view/login/index.php?m=1");
                    exit();
                }
            }
        }
    }

    public function insert_usuario($id_rol, $u_nombre, $u_apellido, $u_correo, $u_usuario, $u_pass)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "INSERT INTO tm_usuario (id_usuario, id_rol, u_nombre, u_apellido, u_correo, u_usuario, u_pass) VALUES (NULL, ?, ?, ?, ?, ?, ?)";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $id_rol);
        $sql->bindValue(2, $u_nombre);
        $sql->bindValue(3, $u_apellido);
        $sql->bindValue(4, $u_correo);
        $sql->bindValue(5, $u_usuario);
        $sql->bindValue(6, $u_pass);
        $sql->execute();
        return $sql->rowCount();
    }

    public function update_usuario($id_usuario, $id_rol, $u_nombre, $u_apellido, $u_correo, $u_usuario)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "UPDATE tm_usuario SET id_rol=?, u_nombre=?, u_apellido=?, u_correo=?, u_usuario=? WHERE id_usuario=?";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $id_rol);
        $sql->bindValue(2, $u_nombre);
        $sql->bindValue(3, $u_apellido);
        $sql->bindValue(4, $u_correo);
        $sql->bindValue(5, $u_usuario);
        $sql->bindValue(6, $id_usuario);
        $sql->execute();
        return $sql->rowCount();
    }

    public function restablecer_password($id_usuario)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "UPDATE tm_usuario SET u_pass = '12345' WHERE id_usuario=?";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $id_usuario);
        $sql->execute();
        return $sql->rowCount();
    }

    public function delete_usuario($id_usuario)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "DELETE FROM tm_usuario WHERE id_usuario=?";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $id_usuario);
        $sql->execute();
        return $sql->rowCount();
    }

    public function get_usuario()
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM tm_usuario";
        $sql = $conectar->prepare($sql);
        $sql->execute();
        return $sql->fetchAll();
    }

    public function get_usuario_por_id($id_usuario)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "SELECT * FROM tm_usuario WHERE id_usuario=?";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $id_usuario);
        $sql->execute();
        return $sql->fetchAll();
    }

    public function update_pass($id_usuario, $u_pass)
    {
        $conectar = parent::conexion();
        parent::set_names();
        $sql = "UPDATE tm_usuario SET u_pass=? WHERE id_usuario=?";
        $sql = $conectar->prepare($sql);
        $sql->bindValue(1, $u_pass);
        $sql->bindValue(2, $id_usuario);
        $sql->execute();
        return $sql->rowCount();
    }
}